/*
 * Decompiled with CFR 0.152.
 */
package jgamebase.model;

import java.applet.Applet;
import java.applet.AudioClip;
import java.awt.Cursor;
import java.io.File;
import java.net.MalformedURLException;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import jgamebase.Const;
import jgamebase.gui.SplashScreen;
import jgamebase.model.DatabaseSelection;
import jgamebase.model.FileExtensions;
import jgamebase.model.Preferences;
import jgamebase.tools.FileTools;
import jgamebase.tools.ListerTools;

public class Database
implements DatabaseSelection {
    private static final String PREFERENCES_FILENAME = "Settings.cfg";
    private String name;
    private String displayName;
    private Icon icon = null;
    private SplashScreen splashscreen = null;
    private AudioClip classicSound = null;
    private Icon missingScreenshotIcon = null;
    private Preferences preferences = null;

    public Preferences getPreferences() {
        return this.preferences;
    }

    public Database(String name) {
        this.name = name;
        File file = Database.findImage(new File(this.getPath(), "Gfx"), "startup_32x32");
        if (file.exists()) {
            this.icon = new ImageIcon(file.toString());
        }
        this.preferences = new Preferences(new File(this.getPath(), PREFERENCES_FILENAME).getAbsolutePath());
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    @Override
    public Icon getIcon() {
        return this.icon;
    }

    public void showSplashscreen() {
        File file = Database.findImage(new File(this.getPath(), "Splash"), "splash");
        if (file.exists()) {
            this.splashscreen = new SplashScreen(file.toString());
            this.splashscreen.setVisible(true);
            this.splashscreen.setCursor(Cursor.getPredefinedCursor(3));
        }
        if ((file = new File(this.getPath(), "Sounds/Classic.wav")).exists()) {
            try {
                this.classicSound = Applet.newAudioClip(file.toURI().toURL());
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
        }
        if ((file = new File(this.getPath(), "Gfx/No_Picture_320x200.gif")).exists()) {
            this.missingScreenshotIcon = new ImageIcon(file.toString());
        }
    }

    public void hideSplashscreen() {
        if (this.splashscreen != null) {
            this.splashscreen.setVisible(false);
            this.splashscreen.setCursor(Cursor.getPredefinedCursor(0));
            this.splashscreen.dispose();
            this.splashscreen = null;
        }
    }

    private static File findImage(File dir, String needle) {
        if (!dir.exists() || !dir.isDirectory()) {
            return new File("");
        }
        FileExtensions imageExtensions = new FileExtensions("gif;png;jpg;bmp");
        List<String> allFilenames = ListerTools.list_Dirs_Files_Paths(dir.getAbsolutePath(), false, true, false);
        List<String> imageFilenames = imageExtensions.getMatching(allFilenames);
        for (String filename : imageFilenames) {
            if (!FileTools.removeExtension(filename).toLowerCase().equals(needle.toLowerCase())) continue;
            return new File(dir, filename);
        }
        if (imageFilenames.size() > 0) {
            return new File(dir, imageFilenames.get((int)((double)(imageFilenames.size() - 1) * Math.random())));
        }
        return new File("");
    }

    public boolean hasClassicSound() {
        return this.classicSound != null;
    }

    public AudioClip getClassicSound() {
        return this.classicSound;
    }

    public boolean hasMissingScreenshotIcon() {
        return this.missingScreenshotIcon != null;
    }

    public Icon getMissingScreenshotIcon() {
        return this.missingScreenshotIcon;
    }

    public File getPath() {
        return new File(Const.GBDIR_RW, this.getName());
    }

    public File getROPath() {
        return new File(Const.GBDIR_RO, this.getName());
    }

    public File getExportPath() {
        File dir = new File(this.getPath(), "Export");
        if (!dir.exists()) {
            dir.mkdirs();
        }
        return dir;
    }

    public File getCleanExportPath() {
        FileTools.deleteAll(this.getExportPath());
        return this.getExportPath();
    }

    public String toString() {
        return this.getName();
    }
}

